### COE通用参数说明

![](https://resource.helplook.net/docker_production/3648ne/article/Z4v0sM7L/68832e39b5eb7.png)

| **参数** | **说明** |
|---|---|
| 2001:01 EtherCATBusErrCOMEN | 参数用于设置模块通讯断开后，设置COM能否正常收发数据：  0：ECT掉线后COM不能正常收发数据；  1：ECT掉线后COM能正常收发数据； |

---

### 参数说明

SRE6002/SRE6004分别为2个串口和4个串口模块，参数说明相同，以下以SRE6004举例说明，SRE6002可参考进行配置使用，所有参数更改后立刻生效，不需断电重启，如下图：

![](https://resource.helplook.net/docker_production/3648ne/article/Z4v0sM7L/68832e39b63d7.png)

| **参数** | **说明** |
|---|---|
| Duplex Mode | 0：全双工（RS232/RS422）1：半双工（RS485） |
| Baudrate | 波特率：  0：1200  1：2400  2：4800  3：9600  4：19200  5：38400  6：57600  7：115200 |
| Data Bit | 数据位：  0：8位  1：7位 |
| Stop Bit | 停止位：  0：1位  1：2位 |
| Parity Bit | 奇偶校验位：  0：无校验  1：奇校验  2：偶校验 |
| ReceiveTimeout | 串口接收超时：  5-200(单位：ms )超范围按范围算,例如：超过200则按200算。 |
| Modbus Master ResponseTimeout | Modbus RTU主站模式响应超时从站超过设定时间没有响应，则判断通讯超时；  5-5000(单位:ms )超范围按范围算，例如：超过5000则按5000算。 |
| Modbus Master Scan Time | Modbus RTU主站模式轮询时间MBS主站模式下，一条完成指令到下一指令的间隔时间；单位：ms。 |

---

### 组态模块说明

每个串口可独立配置为Modbus主站、Modbus从站、自由口；Modbus主站最大可配置32个模块，Modbus从站最大可配置1个模块，自由口最大可配置1个模块。

#### Modbus主站组态

在Slot里面，选择对应串口的模块，添加想要组态的模块，如在串口1添加”Read 32 Words 4xxxx”，每个串口在分配合理的情况下最多可组态32个模块.

组态好以后，添加刷新IO，即可OP

| State | 模块状态：1：通讯正常2：通讯超时3：CRC错误4：功能码或者地址错误 |
|---|---|
| Output Data | 输出地址：Output Data 1~Output Data x |
| Slave ID | 要访问的从站的ID |
| Addr | 要访问的Modbus的地址 |

![](https://resource.helplook.net/docker_production/3648ne/article/Z4v0sM7L/68832e39c25d7.png)

| Input Data | 输入地址：Input Data 1~Input Data x |
|---|---|
| State | 模块状态：1：通讯正常2：通讯超时3：CRC错误4：功能码或者地址错误 |
| Slave ID | 要访问的从站的ID |
| Addr | 要访问的Modbus的地址 |

#### Modbus从站组态

在Slot里面，选择对应串口的模块，添加想要组态的从站模块，每个串口最多可组态1个模块，组态大于1个则无法OP，如下图：

![](https://resource.helplook.net/docker_production/3648ne/article/Z4v0sM7L/68832e39c0aa0.png)

组态好以后，添加刷新IO，即可OP，如下图：

![](https://resource.helplook.net/docker_production/3648ne/article/Z4v0sM7L/68832e39c4b60.png)

| **参数** | **说明** |
|---|---|
| Input Datas： | Input Data 1~Input Data x允许Modbus RTU主站写的数据区，起始地址为40256 |
| Output Datas： | Output Data 1~Output Data x允许Modbus RTU主站读的数据区，起始地址为40001 |
| Slave ID： | 本地从站的ID |

#### 自由口组态

在Slot里面，选择对应串口的模块，添加，每个串口最多可组态1个模块，组态大于1个则无法OP，如下图：

![](https://resource.helplook.net/docker_production/3648ne/article/Z4v0sM7L/68832e39c148f.png)

输入参数说明：

![](https://resource.helplook.net/docker_production/3648ne/article/Z4v0sM7L/68832e39d49a3.png)

| Status状态字含义 | Transmit Done：当前帧数据发送完成； |
|---|---|
| Receive request：有新的数据接收； |
| Init accepted：串口重新初始化完成； |
| SndBuffer full：发送帧长度超过1024； |
| PutData Done：将发送数据写入到发送缓存完成； |
| Input length：当前数据的接收长度； |
| Total input length：数据帧的总长度； |
| Data In 0~Data In 31 | 接收数据缓冲区。 |

输出参数说明：

![](https://resource.helplook.net/docker_production/3648ne/article/Z4v0sM7L/68832e39af5af.png)

| Ctrl控制字含义 | Transmit request：发送请求； |
|---|---|
| Receive accepted：数据已接收； |
| Init request：重新初始化串口； |
| Put data：将发送数据写入到发送缓存； |
| Output length：发送数据帧的总长度； |
| Data Out 0~Data Out 31 | 发送数据缓冲区。 |

进行自由口通讯时，接收或者发送数据前建议先把串口进行初始化，串口初始化成功后需要把初始化控制字Init request置0，否则串口不能正常收发数据。

发送数据：

（1）初始化串口，COM1控制字Init request置1，COM1状态字Init accepted显示为1时则初始化完成。

（2）设置发送数据长度，COM1控制字Output length写入40。

（3）把要发送的数据1~32依次写入到Output1~Output32（每次最大只能把32个字节的数据写到发送缓存区中，如果发送的数据长度大于32个字节时则需要分批次把数据写到发送缓存区，然后再把数据一次性发送出去，例如：发送40个字节的数据，分2次写入到发送缓存区中，然后一次性把40个字节发送出去）

（4）将COM1控制字Transmit request置1，同时将控制字Put data置1；

（5）读取COM1状态字PutData Done，当PutData Done为1时，32字节已经成功写入发送缓存，将控制字Put data置0；

（6）把33~40数据写入Output1~Output8，然后把控制字Put data置1。

（7）当COM1状态字Transmit Done为1时，当前数据帧发送成功，将控制字Transmit request、Put data置0；完成当前帧发送。

接收数据：

（1）当模块接收数据时，COM2状态字Receive request为1，Input length为32表示当前可接收数据为32，Total input length总长度显示为40；

（2）读取Input1~Input32便可读取前32字节，将COM2控制字Receive accepted置1，此时读取COM2状态字Receive request为0的时候，将COM2控制字Receive accepted置0，置0后COM2状态字Receive request显示为1，Input length显示为8，表示有8个字节数据要接收；

（3）此时读取Input1~Input8便读取后8个字节，读取完以后把COM2控制字Receive accepted置1再置0，置0后COM1状态字Receive request显示为1；当前数据帧接收完成。